/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <fstream>

void hexMultiplicationTable (std::streambuf* buffer, int num)
{
    std::ostream hexout(buffer);
    hexout << std::hex << std::showbase;

    for (int i=1; i<=num; ++i) {
        for (int j=1; j<=10; ++j) {
            hexout << i*j << ' ';
        }
        hexout << std::endl;
    }

}   // nie zamyka bufora

int main()
{
    using namespace std;
    int num = 5;

    cout << "Wyswietlamy " << num
         << " wierszy w postaci szesnastkowej" << endl;

    hexMultiplicationTable(cout.rdbuf(),num);

    cout << "Wyswietlilismy " << num
         << " wierszy w postaci szesnastkowej " << endl;
}
