/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <locale>
#include <string>
#include <cstdlib>
using namespace std;

int main()
{
    // utworz domyslny obiekt locale uzywajac zmiennych srodowiskowych
    locale langLocale("");

    // i przypisz go do standardowego kanalu wyjsciowego
    cout.imbue(langLocale);

    // przetworz nazwe ciagu definiujacego ustawienia lokalne
    bool isGerman;
    if (langLocale.name() == "de_DE" ||
        langLocale.name() == "de" ||
        langLocale.name() == "german") {
          isGerman = true;
    }
    else {
          isGerman = false;
    }

    // odczytaj nazwe ciagu definiujacego ustawienia lokalne ze standardowego wyjscia
    if (isGerman) {
        cout << "Sprachumgebung fuer Eingaben: ";
    }
    else {
        cout << "Ustawienia lokalne dla danych wejsciowych: ";
    }
    string s;
    cin >> s;
    if (!cin) {
        if (isGerman) {
            cerr << "FEHLER beim Einlesen der Sprachumgebung"
                 << endl;
        }
        else {
            cerr << "BLAD podczas wczytywania nazwy" << endl;
        }
        return EXIT_FAILURE;
    }
    locale cinLocale(s.c_str());

    // i przyporzadkuj ja do standardowego kanalu wejsciowego
    cin.imbue(cinLocale);

    // odczytaj w petli wartosci zmiennoprzecinkowe i wypisz je na ekranie
    double value;
    while (cin >> value) {
        cout << value << endl;
    }
}
