/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include "print.hpp"
using namespace std;

class Nth {    // obiekt funkcyjny zwracajacy wartosc true przy n-tym wywolaniu
  private:
    int nth;       // numer wywolania, dla ktorego zwrocona ma zostac wartosc true
    int count;     // licznik wywolan
  public:
    Nth (int n) : nth(n), count(0) {
    }
    bool operator() (int) {
        return ++count == nth;
    }
};

int main()
{
    list<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }
    PRINT_ELEMENTS(coll,"kontener coll:         ");

    // usun trzeci element
    list<int>::iterator pos;
    pos = remove_if(coll.begin(),coll.end(),  // zakres
                    Nth(3));                  // kryterium usuniecia
    coll.erase(pos,coll.end());

    PRINT_ELEMENTS(coll,"usunieto n-ty element: ");
}
