/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <algorithm>
#include <iterator>
using namespace std;

// dolacz samodzielnie zdefiniowany obiekt funkcyjny fopow<>
#include "fopow.hpp"

int main()
{
    vector<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }

    // wypisz wyniki otrzymane w wyniku podniesienia wartosci 3 do poteg wszystkich elementow
    transform (coll.begin(), coll.end(),         // zrodlo
               ostream_iterator<int>(cout," "),  // przeznaczenie
               bind1st(fopow<float,int>(),3));   // operacja
    cout << endl;

    // wypisz wszystkie elementy podniesione do potegi 3
    transform (coll.begin(), coll.end(),         // zrodlo
               ostream_iterator<int>(cout," "),  // przeznaczenie
               bind2nd(fopow<float,int>(),3));   // operacja
    cout << endl;
}
