/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <string>
#include "Queue.hpp"      // uzyj specjalnej klasy kolejki
using namespace std;

int main()
{
   try {    
      Queue<string> q;

      // do kolejki wstaw trzy elementy
      q.push("Tu ");
      q.push("sa ");
      q.push("wiecej niz ");

      // z kolejki odczytaj i wypisz dwa elementy
      cout << q.pop();
      cout << q.pop();

      // wstaw dwa nowe elementy
      q.push("cztery ");
      q.push("slowa!");

      // opusc jeden element
      q.pop();

      // z kolejki odczytaj i wypisz dwa elementy
      cout << q.pop();
      cout << q.pop() << endl;

      // wypisz liczbe pozostalych elementow
      cout << "liczba elementow w kolejce: " << q.size()
           << endl;

      // odczytaj i wypisz jeden element
      cout << q.pop() << endl;
   }
   catch (const exception& e) {
      cerr << "WYJATEK: " << e.what() << endl;
   }
}
