/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include <iterator>
using namespace std;

int main()
{
    /* typ kolekcji:
     * - powtorzenia dozwolone
     * - elementy sa wartosciami calkowitymi
     * - porzadek malejacy
     */
    typedef multiset<int,greater<int> > IntSet;

    IntSet coll1;        // pusty wielozbior

    // wstaw elementy w przypadkowej kolejnosci
    coll1.insert(4);
    coll1.insert(3);
    coll1.insert(5);
    coll1.insert(1);
    coll1.insert(6);
    coll1.insert(2);
    coll1.insert(5);

    // iteruj po wszystkich elementach i wypisz je
    IntSet::iterator pos;
    for (pos = coll1.begin(); pos != coll1.end(); ++pos) {
        cout << *pos << ' ';
    }
    cout << endl;

    // wstaw ponownie wartosc 4 i przetworz wartosc zwracana
    IntSet::iterator ipos = coll1.insert(4);
    cout << "wartosc 4 wstawiono jako element "
         << distance(coll1.begin(),ipos) + 1
         << endl;

    // przypisz elementy do innego wielozbioru o porzadku rosnacym
    multiset<int> coll2(coll1.begin(),
                        coll1.end());
    
    // wypisz wszystkie elementy kopii
    copy (coll2.begin(), coll2.end(),
          ostream_iterator<int>(cout," "));
    cout << endl;

    // usun wszystkie elementy az do elementu o wartosci 3
    coll2.erase (coll2.begin(), coll2.find(3));

    // usun wszystkie elementy o wartosci 5
    int num;
    num = coll2.erase (5);
    cout << "usunieto " << num << " element(-y)" << endl;

    // wypisz wszystkie elementy
    copy (coll2.begin(), coll2.end(),
          ostream_iterator<int>(cout," "));
    cout << endl;
}
