/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include <iterator>

using namespace std;

void printLists (const list<int>& l1, const list<int>& l2)
{
    cout << "list1: ";
    copy (l1.begin(), l1.end(), ostream_iterator<int>(cout," "));
    cout << endl << "list2: ";
    copy (l2.begin(), l2.end(), ostream_iterator<int>(cout," "));
    cout << endl << endl;
}

int main()
{
    // utworz dwie puste listy
    list<int> list1, list2;

    // wypelnij obydwie listy elementami
    for (int i=0; i<6; ++i) {
        list1.push_back(i);
        list2.push_front(i);
    }
    printLists(list1, list2);

    // wstaw wszystkie elementy kontenera list1 przed pierwszy element kontenera list2 o wartosci 3
    // - algorytm find() zwraca iterator do pierwszego elementu o wartosci 3
    list2.splice(find(list2.begin(),list2.end(),  // pozycja docelowa
                      3),
                 list1);                          // lista zrodlowa
    printLists(list1, list2);

    // przenies pierwszy element na koniec
    list2.splice(list2.end(),        // pozycja docelowa
                 list2,              // lista zrodlowa
                 list2.begin());     // pozycja zrodlowa
    printLists(list1, list2);

    // posortuj druga liste, przypisz do kontenera list1 i usun powtorzenia
    list2.sort();
    list1 = list2;
    list2.unique();
    printLists(list1, list2);

    // scal obydwie posortowane listy w pierwsza liste
    list1.merge(list2);
    printLists(list1, list2);
}
