/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    list<int> coll;

    INSERT_ELEMENTS(coll,2,6);
    INSERT_ELEMENTS(coll,4,9);
    PRINT_ELEMENTS(coll);

    // wypisz wszystkie elementy o wartosci 5 zastapione wartoscia 55
    replace_copy(coll.begin(), coll.end(),           // zrodlo
                 ostream_iterator<int>(cout," "),    // przeznaczenie
                 5,                                  // stara wartosc
                 55);                                // nowa wartosc
    cout << endl;

    // wypisz wszystkie elementy o wartosci wiekszej od 5 zastapione wartoscia 42
    replace_copy_if(coll.begin(), coll.end(),        // zrodlo
                    ostream_iterator<int>(cout," "), // przeznaczenie
                    bind2nd(less<int>(),5),     // kryterium zastapienia
                    42);                        // nowa wartosc
    cout << endl;

    // wypisz kazdy element, przy czym kazdy element nieparzysty zastapiony ma byc wartoscia 0
    replace_copy_if(coll.begin(), coll.end(),        // zrodlo
                    ostream_iterator<int>(cout," "), // przeznaczenie
                    bind2nd(modulus<int>(),2),  // kryterium zastapienia
                    0);                         // nowa wartosc
    cout << endl;
}
