/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    deque<int> coll;

    INSERT_ELEMENTS(coll,3,7);
    INSERT_ELEMENTS(coll,2,6);
    INSERT_ELEMENTS(coll,1,5);
    PRINT_ELEMENTS(coll);

    // sortuj do momentu, gdy posortowanych bedzie piec pierwszych elementow
    partial_sort (coll.begin(),      // poczatek zakresu
                  coll.begin()+5,    // koniec posortowanego zakresu
                  coll.end());       // koniec pelnego zakresu
    PRINT_ELEMENTS(coll);

    // sortuj odwrotnie do momentu, gdy posortowanych bedzie piec pierwszych elementow
    partial_sort (coll.begin(),      // poczatek zakresu
                  coll.begin()+5,    // koniec posortowanego zakresu
                  coll.end(),        // koniec pelnego zakresu
                  greater<int>());   // kryterium sortowania
    PRINT_ELEMENTS(coll);

    // sortuj wszystkie elementy
    partial_sort (coll.begin(),      // poczatek zakresu
                  coll.end(),        // koniec posortowanego zakresu
                  coll.end());       // koniec pelnego zakresu
    PRINT_ELEMENTS(coll);
}
