/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    deque<int> coll;

    INSERT_ELEMENTS(coll,3,7);
    INSERT_ELEMENTS(coll,2,6);
    INSERT_ELEMENTS(coll,1,5);
    PRINT_ELEMENTS(coll);

    // wyluskaj cztery najmniejsze elementy
    nth_element (coll.begin(),     // poczatek zakresu
                 coll.begin()+3,   // element, ktory powinien byc na wlasciwej pozycji
                 coll.end());      // koniec zakresu

    // wypisz je
    cout << "cztery najmniejsze elementy to:  ";
    copy (coll.begin(), coll.begin()+4,
          ostream_iterator<int>(cout," "));
    cout << endl;

    // wyluskaj cztery najwieksze elementy
    nth_element (coll.begin(),     // poczatek zakresu
                 coll.end()-4,     // element, ktory powinien byc na wlasciwej pozycji
                 coll.end());      // koniec zakresu

    // wypisz je
    cout << "cztery najwieksze elementy to:   ";
    copy (coll.end()-4, coll.end(),
          ostream_iterator<int>(cout," "));
    cout << endl;

    // wyluskaj cztery najwieksze elementy (druga wersja)
    nth_element (coll.begin(),     // poczatek zakresu
                 coll.begin()+3,   // element, ktory powinien byc na wlasciwej pozycji
                 coll.end(),       // koniec zakresu
                 greater<int>());  // kryterium sortowania

    // wypisz je
    cout << "cztery najwieksze elementy to:   ";
    copy (coll.begin(), coll.begin()+4,
          ostream_iterator<int>(cout," "));
    cout << endl;
}
