/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <cstdlib>
#include "algostuff.hpp"
using namespace std;

bool absLess (int elem1, int elem2)
{
    return abs(elem1) < abs(elem2);
}

int main()
{
    deque<int> coll;

    INSERT_ELEMENTS(coll,2,8);
    INSERT_ELEMENTS(coll,-3,5);

    PRINT_ELEMENTS(coll);

    // wyznacz i wypisz wartosc najmniejsza i najwieksza
    cout << "wartosc najmniejsza: "
         << *min_element(coll.begin(),coll.end())
         << endl;
    cout << "wartosc najwieksza:  "
         << *max_element(coll.begin(),coll.end())
         << endl;

    // wyznacz i wypisz najmniejsza i najwieksza z wartosci bezwzglednych
    cout << "najmniejsza z wartosci bezwzglednych: "
         << *min_element(coll.begin(),coll.end(),
                         absLess)
         << endl;
    cout << "najwieksza z wartosci bezwzglednych:  "
         << *max_element(coll.begin(),coll.end(),
                         absLess)
         << endl;
}
