/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    list<int> coll;

    INSERT_ELEMENTS(coll,1,6);
    PRINT_ELEMENTS(coll);

    /* oblicz sume wszystkich iloczynow
     * (0 + 1*1 + 2*2 + 3*3 + 4*4 + 5*5 + 6*6)
     */
    cout << "iloczyn skalarny: "
         << inner_product (coll.begin(), coll.end(),  // pierwszy zakres
                           coll.begin(),              // drugi zakres
                           0)                         // wartosc poczatkowa
         << endl;

    /* oblicz sume 1*6 ... 6*1
     * (0 + 1*6 + 2*5 + 3*4 + 4*3 + 5*2 + 6*1)
     */
    cout << "odwrotny iloczyn skalarny: "
         << inner_product (coll.begin(), coll.end(),  // pierwszy zakres
                           coll.rbegin(),             // drugi zakres
                           0)                         // wartosc poczatkowa
         << endl;

    /* oblicz iloczyn sum
     * (1 * 1+1 * 2+2 * 3+3 * 4+4 * 5+5 * 6+6)
     */
    cout << "iloczyn sum: "
         << inner_product (coll.begin(), coll.end(),  // pierwszy zakres
                           coll.begin(),              // drugi zakres
                           1,                         // wartosc poczatkowa
                           multiplies<int>(),       // operacja zewnetrzna
                           plus<int>())             // operacja wewnetrzna
         << endl;
}
