/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll1;
    list<int> coll2;

    INSERT_ELEMENTS(coll1,1,9);

    /* kopiuj elementy kolekcji coll1 do coll2
     * - uzyj wstawiacza koncowego, aby elementy byly wstawiane a nie nadpisywane
     */
    copy (coll1.begin(), coll1.end(),         // zakres zrodlowy
          back_inserter(coll2));              // zakres docelowy

    /* wypisz elementy kolekcji coll2
     * - kopiuj elementy do strumienia cout przy uzyciu iteratora strumieniowego wyjsciowego
     */
    copy (coll2.begin(), coll2.end(),         // zakres zrodlowy
          ostream_iterator<int>(cout," "));   // zakres docelowy
    cout << endl;

    /* kopiuj elementy kolekcji coll1 do coll2 w odwrotnej kolejnosci
     * - teraz nadpisywanie
     */
    copy (coll1.rbegin(), coll1.rend(),       // zakres zrodlowy
          coll2.begin());                     // zakres docelowy

    // ponownie wypisz elementy kolekcji coll2
    copy (coll2.begin(), coll2.end(),         // zakres zrodlowy
          ostream_iterator<int>(cout," "));   // zakres docelowy
    cout << endl;
}
