/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

// zwraca, czy drugi obiekt posiada podwojona wartosc pierwszego
bool doubled (int elem1, int elem2)
{
   return elem1 * 2 == elem2;
}

int main()
{
   vector<int> coll;

   coll.push_back(1);
   coll.push_back(3);
   coll.push_back(2);
   coll.push_back(4);
   coll.push_back(5);
   coll.push_back(5);
   coll.push_back(0);

   PRINT_ELEMENTS(coll,"coll: ");

   // szukaj pierwszych dwoch elementow o rownej wartosci
   vector<int>::iterator pos;
   pos = adjacent_find (coll.begin(), coll.end());

   if (pos != coll.end()) {
       cout << "pierwsze dwa elementy o rownej wartosci maja pozycje "
            << distance(coll.begin(),pos) + 1
            << endl;
   }

   // szukaj pierwszych dwoch elementow takich, ze drugi posiada podwojona wartosc pierwszego
   pos = adjacent_find (coll.begin(), coll.end(),   // zakres
                        doubled);                   // kryterium

   if (pos != coll.end()) {
       cout << "pierwsze dwa elementy o drugiej wartosci bedacej podwojona "
            << "pierwsza maja poz. "
            << distance(coll.begin(),pos) + 1
            << endl;
   }
}
