/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll;

    INSERT_ELEMENTS(coll,1,9);
    PRINT_ELEMENTS(coll);

    // oblicz sume elementow
    cout << "suma: "
         << accumulate (coll.begin(), coll.end(),    // zakres
                        0)                           // wartosc poczatkowa
         << endl;

    // oblicz sume elementow minus 100
    cout << "suma: "
         << accumulate (coll.begin(), coll.end(),    // zakres
                        -100)                        // wartosc poczatkowa
         << endl;

    // oblicz iloczyn elementow
    cout << "iloczyn: "
         << accumulate (coll.begin(), coll.end(),    // zakres
                        1,                           // wartosc poczatkowa
                        multiplies<int>())           // operacja
         << endl;

    // oblicz iloczyn elementow (jako wartosc poczatkowa zastosuj 0)
    cout << "iloczyn: "
         << accumulate (coll.begin(), coll.end(),    // zakres
                        0,                           // wartosc poczatkowa
                        multiplies<int>())           // operacja
         << endl;
}
