/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <memory>
using namespace std;

/* zdefiniuj operator wyjscia dla auto_ptr
 * - wyswietl wartosc obiektu lub wartosc NULL
 */
template <class T>
ostream& operator<< (ostream& strm, const auto_ptr<T>& p)
{
    // czy p posiada obiekt?
    if (p.get() == NULL) {
        strm << "NULL";         // NIE: wypisz NULL
    }
    else {
        strm << *p;             // TAK: wypisz obiekt
    }
    return strm;
}

int main()
{
    const auto_ptr<int> p(new int(42));
    const auto_ptr<int> q(new int(0));
    const auto_ptr<int> r;

    cout << "po inicjalizacji:" << endl;
    cout << " p: " << p << endl;
    cout << " q: " << q << endl;
    cout << " r: " << r << endl;

    *q = *p;
//  *r = *p;    // BLAD: zachowanie niezdefiniowane
    *p = -77;
    cout << "po przypisaniu wartosci:" << endl;
    cout << " p: " << p << endl;
    cout << " q: " << q << endl;
    cout << " r: " << r << endl;

//  q = p;      // BLAD kompilacji
//  r = p;      // BLAD kompilacji
}
