/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <map>
#include <string>
using namespace std;

int main()
{
    // typ kolekcji
    typedef multimap<int,string> IntStringMMap;

    IntStringMMap coll;        // kontener na wartosci typu int-string

    // wstaw kilka elementow w przypadkowej kolejnosci
    // - wartosc o kluczu 1 wstawiana jest dwukrotnie
    coll.insert(make_pair(5,"oznakowanych"));
    coll.insert(make_pair(2,"multimapa"));
    coll.insert(make_pair(1,"to"));
    coll.insert(make_pair(4,"z"));
    coll.insert(make_pair(6,"lancuchow"));
    coll.insert(make_pair(1,"jest"));
    coll.insert(make_pair(3,"zlozona"));

    /* wypisz wszystkie wartosci elementow
     * - iteruj po wszystkich elementach
     * - druga skladowa elementu to wartosc
     */
    IntStringMMap::iterator pos;
    for (pos = coll.begin(); pos != coll.end(); ++pos) {
        cout << pos->second << ' ';
    }
    cout << endl;
}
