/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main()
{
    vector<int> coll1;    // pusta kolekcja
    vector<int> coll2;    // pusta kolekcja

    /* BLAD WYKONANIA:
     * - poczatek znajduje sie za koncem zakresu
     */
    vector<int>::iterator pos = coll1.begin();
    reverse (++pos, coll1.end());

    // wstaw elementy od 1 do 9 do kolekcji coll2
    for (int i=1; i<=9; ++i) {
        coll2.push_back (i);
    }

    /* BLAD WYKONANIA:
     * - nadpisanie nieistniejcych elementow
     */
    copy (coll2.begin(), coll2.end(),    // zrodlo
          coll1.begin());                // przeznaczenie

    /* BLAD WYKONANIA:
     * - pomylone kolekcje
     * - pomylone funkcje begin() oraz end()
     */
    copy (coll1.begin(), coll2.end(),    // zrodlo
          coll1.end());                  // przeznaczenie
}
