/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iterator>

/* klasa wzorcowa iteratora wstawiajacego dla kontenerow asocjacyjnych
 */
template <class Container>
class asso_insert_iterator
 : public std::iterator <std::output_iterator_tag,
                         void, void, void, void>
{
  protected:
    Container& container;    // kontener, do ktorego wstawiane sa elementy

  public:
    // konstruktor
    explicit asso_insert_iterator (Container& c) : container(c) {
    }

    // operator przypisania
    // - wstawia wartosc do kontenera
    asso_insert_iterator<Container>&
    operator= (const typename Container::value_type& value) { 
        container.insert(value);
        return *this;
    }

    // operacja dereferencji jest rozkazem pustym, ktory zwraca sam iterator
    asso_insert_iterator<Container>& operator* () {
        return *this;
    }

    // operacja inkrementacji jest rozkazem pustym, ktory zwraca sam iterator
    asso_insert_iterator<Container>& operator++ () {
        return *this;
    }
    asso_insert_iterator<Container>& operator++ (int) {
        return *this;
    }
};

/* wygodna funkcja do tworzenia wstawiacza
 */
template <class Container>
inline asso_insert_iterator<Container> asso_inserter (Container& c)
{
    return asso_insert_iterator<Container>(c);
}
