/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <sstream>
#include <bitset>
using namespace std;

int main()
{
    ostringstream os;

    // wartosc dziesietna oraz szesnastkowa
    os << "s.dziesietny: " << 15 << hex << " s.szesnastkowy: " << 15 << endl;
    cout << os.str() << endl;

    // dolacz wartosc rzeczywista oraz pole bitowe
    bitset<15> b(5789);
    os << "liczba rzeczywista: " << 4.67 << " pole bitowe: " << b << endl;

    // nadpisz wartoscia osemkowa
    os.seekp(0);
    os << "s.osemkowy: " << oct << 15;
    cout << os.str() << endl;
}
