/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>       // dla lancuchow znakowych
#include <iostream>     // dla operacji wejscia-wyjscia
#include <fstream>      // dla operacji wejscia-wyjscia na plikach
#include <iomanip>      // dla setw()
#include <cstdlib>      // dla exit()
using namespace std;

// deklaracje zapowiadajace
void writeCharsetToFile (const string& filename);
void outputFile (const string& filename);

int main ()
{
    writeCharsetToFile("charset.out");
    outputFile("charset.out");
}

void writeCharsetToFile (const string& filename)
{
    // otworz plik wyjsciowy
    ofstream file(filename.c_str());

    // czy plik zostal otworzony prawidlowo?
    if (! file) {
        // NIE, przerwij dzialanie programu
        cerr << "nie moge otworzyc pliku wyjsciowego \"" << filename << "\""
             << endl;
        exit(EXIT_FAILURE);
    }

    // zapisz zestaw znakow
    for (int i=32; i<256; i++) {
        file << "wartosc: " << setw(3) << i << "   "
             << "znak:  " << static_cast<char>(i) << endl;
    }

}   // plik zostanie zemkniety automatycznie

void outputFile (const string& filename)
{
    // otworz plik wejsciowy
    ifstream file(filename.c_str());

    // czy plik zostal otworzony prawidlowo?
    if (! file) {
        // NIE, przerwij dzialanie programu
        cerr << "nie moge otworzyc pliku wejsciowego \"" << filename << "\""
             << endl;
        exit(EXIT_FAILURE);
    }

    // przekopiuj zawartosc do strumienia cout
    char c;
    while (file.get(c)) {
        cout.put(c);
    }

}   // plik zostanie zamkniety automatycznie
