/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <string>
#include <algorithm>
#include <vector>
#include <iterator>
using namespace std;

int main()
{
    /* utworz wektor lancuchow
     * - inicjalizowany wszystkimi slowami z wejscia standardowego
     */
    vector<string> coll((istream_iterator<string>(cin)),
                        (istream_iterator<string>()));

    // posortuj elementy
    sort (coll.begin(), coll.end());

    // wypisz wszystkie elementy z pominieciem kolejnych elementow powtarzajacych sie
    unique_copy (coll.begin(), coll.end(),
                 ostream_iterator<string>(cout, "\n"));
}
