/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll1;
    list<int> coll2;

    INSERT_ELEMENTS(coll1,1,9);
    PRINT_ELEMENTS(coll1,"coll1:    ");

    // kazdy element podnies do kwadratu
    transform (coll1.begin(), coll1.end(),       // pierwszy zakres zrodlowy
               coll1.begin(),                    // drugi zakres zrodlowy
               coll1.begin(),                    // zakres docelowy
               multiplies<int>());               // operacja
    PRINT_ELEMENTS(coll1,"kwadraty: ");

    /* dodaj kazdy element poczawszy od poczatku do odpowiedniego elementu wzietego od konca
     * i wstaw wynik do kolekcji coll2
     */
    transform (coll1.begin(), coll1.end(),       // pierwszy zakres zrodlowy
               coll1.rbegin(),                   // drugi zakres zrodlowy
               back_inserter(coll2),             // zakres docelowy
               plus<int>());                     // operacja
    PRINT_ELEMENTS(coll2,"coll2:    ");

    // wypisz roznice dwoch odpowiadajacych sobie elementow
    cout << "roznice:  ";
    transform (coll1.begin(), coll1.end(),       // pierwszy zakres zrodlowy
               coll2.begin(),                    // drugi zakres zrodlowy
               ostream_iterator<int>(cout, " "), // zakres docelowy
               minus<int>());                    // operacja
    cout << endl;
}
