/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    // wypisz dziesiec razy wartosc 7.7
    fill_n(ostream_iterator<float>(cout, " "), // poczatek zakresu docelowego
           10,                                 // liczba elementow
           7.7);                               // nowa wartosc
    cout << endl;

    list<string> coll;

    // wstaw dziewiec razy lancuch "witaj"
    fill_n(back_inserter(coll),       // poczatek zakresu docelowego
           9,                         // liczba elementow
           "witaj");                  // nowa wartosc
    PRINT_ELEMENTS(coll,"coll: ");

    // nadpisz wszystkie elementy lancuchem "znowu"
    fill(coll.begin(), coll.end(),    // zakres docelowy
         "znowu");                    // nowa wartosc
    PRINT_ELEMENTS(coll,"coll: ");

    // zastap wszystkie elementy oprocz dwoch lancuchem "czesc"
    fill_n(coll.begin(),              // poczatek zakresu docelowego
           coll.size()-2,             // liczba elementow
           "czesc");                  // nowa wartosc
    PRINT_ELEMENTS(coll,"coll: ");

    // zastap elementy od drugiego do przedostatniego lancuchem "hmmm"
    list<string>::iterator pos1, pos2;
    pos1 = coll.begin();
    pos2 = coll.end();
    fill (++pos1, --pos2,              // zakres docelowy
          "hmmm");                     // nowa wartosc
    PRINT_ELEMENTS(coll,"coll: ");
}
