/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <unordered_map>
#include <string>
#include <iostream>
using namespace std;

int main()
{
    unordered_map<string,double> coll { { "lolek", 9.9 },
                                        { "bolek", 11.77 }
                                      };

    // wypisz kwadraty wszystkich elementów (wartości)
    for (pair<const string,double>& elem : coll) {
        elem.second *= elem.second;
    }

    // wypisz wszystkie elementy (klucze i wartości)
    for (const auto& elem : coll) {
        cout << elem.first << ": " << elem.second << endl;
    }
}
