/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <vector>
#include <algorithm>
using namespace std;

int main()
{
    vector<int> coll1;    // pusta kolekcja
    vector<int> coll2;    // pusta kolekcja

    // BŁĄD WYKONANIA:
    // - początek znajduje się za końcem zakresu
    vector<int>::iterator pos = coll1.begin();
    reverse (++pos, coll1.end());

    // wstaw elementy od 1 do 9 do kolekcji coll1
    for (int i=1; i<=9; ++i) {
        coll1.push_back (i);
    }

    // BŁĄD WYKONANIA:
    // - nadpisanie nieistniejących elementów
    copy (coll1.cbegin(), coll1.cend(),  // źródło
          coll1.begin());                // przeznaczenie

    // BŁĄD WYKONANIA:
    // - pomylone kolekcje
    // - pomylone funkcje cbegin() oraz cend()
    copy (coll1.cbegin(), coll2.cend(),  // źródło
          coll1.end());                  // przeznaczenie
}
