/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iterator>
#include <algorithm>
#include <vector>
#include <string>
#include <iostream>
using namespace std;

int main()
{
    vector<string> coll;

    // z wejścia standardowego odczytaj wszystkie słowa
    // - źródło: wszystkie łańcuchy do napotkania znaku końca pliku (EOF) lub do wystąpienia błędu
    // - przeznaczenie: kolekcja coll (wstawianie)
    copy (istream_iterator<string>(cin),    // poczatek źródła
          istream_iterator<string>(),       // koniec źrodła
          back_inserter(coll));             // przeznaczenie

    // posortuj elementy
    sort (coll.begin(), coll.end());

     // wypisz wszystkie elementy bez powtórzeń
    // - źródło: kolekcja coll
    // - przeznaczenie: wyjście standardowe (elementy rozdzielone znakami nowego wiersza)
    unique_copy (coll.cbegin(), coll.cend(),           // źródło
                 ostream_iterator<string>(cout,"\n")); // przeznaczenie
}
