/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iterator>
#include <iostream>
#include <list>
#include <algorithm>
using namespace std;

int main()
{
    // utwórz listę z elementami od 1 do 9
    list<int> coll = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };

    // ustal pozycję elementu o wartości 5
    list<int>::const_iterator pos;
    pos = find (coll.cbegin(), coll.cend(),  // zakres
                5);                          // wartość

    // wypisz wartość elementu
    cout << "pos:   " << *pos << endl;

    // konwertuj iterator na iterator odwrotny
    list<int>::const_reverse_iterator rpos(pos);

    // wypisz wartość elementu, do którego odnosi sie iterator odwrotny
    cout << "rpos:  " << *rpos << endl;

    // konwertuj iterator odwrotny z powrotem na iterator normalny
    list<int>::const_iterator rrpos;
    rrpos = rpos.base();

    // wypisz wartość elementu, do którego odnosi się iterator normalny
    cout << "rrpos: " << *rrpos << endl;
}
