/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
using namespace std;

void print (int elem)
{
    cout << elem << ' ';
}

int main()
{
    // utwórz listę z elementami od 1 to 9
    list<int> coll = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };

    // wypisz wszystkie elementy w normalnej kolejności
    for_each (coll.begin(), coll.end(),      // zakres
              print);                        // operacja
    cout << endl;

    // wypisz wszystkie elementy w odwrotnej kolejności
    for_each (coll.rbegin(), coll.rend(),    // zakres
              print);                        // operacja
    cout << endl;
}
