/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    // utwórz iterator dla strumienia wyjściowego cout
    // - wartości rozdzielane są znakiem nowego wiersza
    ostream_iterator<int> intWriter(cout,"\n");

    // zapisz elementy z wykorzystaniem typowego interfejsu iteratora
    *intWriter = 42;
    intWriter++;
    *intWriter = 77;
    intWriter++;
    *intWriter = -5;

    // utwórz kolekcję zawierającą elementy od 1 do 9
    vector<int> coll = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };

    // zapisz wszystkie elementy bez separatora
    copy (coll.cbegin(), coll.cend(),
          ostream_iterator<int>(cout));
    cout << endl;

    // zapisz wszystkie elementy z separatorem " < "
    copy (coll.cbegin(), coll.cend(),
          ostream_iterator<int>(cout," < "));
    cout << endl;
}
