/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <cstdlib>
#include <iostream>
using namespace std;

int main()
{
    double x, y;        // argumenty

    // wyświetl nagłówek
    cout << "Mnozenie dwoch liczb zmiennoprzecinkowych" << endl;

    // pobierz pierwszy argument
    cout << "pierwszy argument:  ";
    if (! (cin >> x)) {
        // błąd wejścia
        //  => wypisz komunikat o wystąpieniu błędu i zakończ program z kodem błędu
        cerr << "błąd podczas odczytywania pierwszej wartości rzeczywistej"
             << endl;
        return EXIT_FAILURE;
    }

    // pobierz drugi argument
    cout << "drugi argument: ";
    if (! (cin >> y)) {
        // błąd wejścia
        //  => wypisz komunikat o wystąpieniu błędu i zakończ program z kodem błędu
        cerr << "błąd podczas odczytywania drugiej wartości rzeczywistej"
             << endl;
        return EXIT_FAILURE;
    }

    // wyświetl argumenty i wynik dzialania
    cout << x << " razy " << y << " wynosi " << x * y << endl;
}
