/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>

template <typename charT, typename traits>
inline
std::basic_istream<charT,traits>&
operator >> (std::basic_istream<charT,traits>& strm, Fraction& f)
{
    int n, d;

    // odczytaj wartość licznika
    strm >> n;

    // jeśli dostępny
    // - odczytaj znak '/' oraz wartość mianownika
    if (strm.peek() == '/') {
        strm.ignore();
        strm >> d;
    }
    else {
        d = 1;
    }

    // jesli mianownik ma wartość zero
    // - ustaw failbit w celu zasygnalizowania błędu formatu wejścia-wyjścia
    if (d == 0) {
        strm.setstate(std::ios::failbit);
        return strm;
    }

    // jeśli do tej chwili wszystkie operacje zostały wykonane poprawnie
    // zmień wartość mianownika
    if (strm) {
        f = Fraction(n,d);
    }

    return strm;
}
