/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <locale>
#include <iostream>
#include <iterator>
#include <exception>
#include <cstdlib>

int main()
{
    // utwórz kopię bieżącego globalnego obiektu ustawień lokalnych
    std::locale loc;

    // iterator odczytu ze strumienia standardowego wejścia
    typedef std::istreambuf_iterator<char> InIt;
    InIt beg = InIt(std::cin);
    InIt end = InIt();

    // strumień definiujący format wejściowy
    std::ios_base& fmt = std::cin;

    // deklaracja argumentów wyjściowych
    std::ios_base::iostate err;
    float value;

    //pobierz aspekt określający formatowanie danych wejściowych dla obiektu loc
    std::num_get<char, InIt> const& ng
      = std::use_facet<std::num_get<char, InIt> >(loc);

    //odczytaj wartość przy użyciu aspektu formatowania wejściowych danych liczbowych
    ng.get(beg, end, fmt, err, value);

    // wypisz wartość albo kod błędu
    if (err == std::ios_base::goodbit) {
        std::cout << "wartość: " << value << '\n';
    }
    else if (err == std::ios_base::eofbit) {
        std::cout << "wartość: " << value << " (napotkano koniec strumienia [EOF])\n";
    }
    else if (err & std::ios_base::badbit) {
        std::cerr << "błąd przy wczytywaniu wartości liczbowej\n";
        return EXIT_FAILURE;
    }
    else if (err & std::ios_base::failbit) {
        std::cerr << "błąd formatowania przy wczytywaniu wartości liczbowej\n";
        return EXIT_FAILURE;
    }
}
