/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <locale>
#include <string>
#include <cstdlib>
#include <exception>
using namespace std;

int main()
{
    try {
        // utwórz domyślny obiekt locale ze zmiennych środowiskowych
        locale langLocale("");

        // i przypisz go do standardowego kanalu wyjsciowego
        cout.imbue(langLocale);

        // przetworz nazwe ciagu definiujacego ustawienia lokalne
        cout << langLocale.name() << endl;
        bool isGerman = (langLocale.name().substr(0,2) == "de" ||
                         langLocale.name().substr(0,3) == "ger" ||
                         langLocale.name().substr(0,3) == "Ger");

        // odczytaj etykietę ustawień lokalnych ze standardowego wejścia
        cout << (isGerman ? "Sprachumgebung fuer Eingaben: "
                          : "Ustawienia lokalne dla wejścia: "
             << endl;

        string s;
        cin >> s;
        if (!cin) {
            if (isGerman) {
                cerr << "FEHLER beim Einlesen der Sprachumgebung"
                     << endl;
            }
            else {
                cerr << "BLAD podczas wczytywania nazwy" << endl;
            }
            return EXIT_FAILURE;
        }
        locale cinLocale(s); // inicjalizacja locale łańcuchem string (od C++11)

        // i przyporządkuj ją do standardowego kanału wejściowego
        cin.imbue(cinLocale);

        // odczytaj w pętli wartości zmiennoprzecinkowe i wypisz je na ekranie
        cout << (isGerman ? "Gleitkommawerte: "
                          : "wartości zmiennoprzecinkowe: ") << endl;
        double value;
        while (cin >> value) {
            cout << value << endl;
        }
    } catch (const std::exception& e) {
        cerr << "WYJĄTEK: " << e.what() << endl;
        return EXIT_FAILURE;
    }
}
