/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <future>
#include <list>
#include <iostream>
#include <exception>
using namespace std;

void task1()
{
   // nieskończone wstawianie elementu i alokacja pamięci
   // - prędzej czy później spowoduje zgłoszenie wyjątku
   // - UWAGA: to jest zła praktyka
   list<int> v;
   while (true) {
       for (int i=0; i<1000000; ++i) {
           v.push_back(i);
       }
       cout.put('.').flush();
   }
}

int main()
{
    cout << "uruchomienie 2 zadań" << endl;
    cout << "- task1: przetwarzanie nieskończonej pętli zużywającej pamięć" << endl;
    cout << "- task2: oczekiwanie na zwrócenie sterowania, a następnie na zakończenie zadania task1" << endl;

    auto f1 = async(task1); // uruchomienie zadania task1() asynchronicznie (teraz, później lub nigdy)

    cin.get(); // czytanie znaku (podobnie jak getchar())

    cout << "\noczekiwanie na zakończenie zadania task1: " << endl;
    try {
        f1.get(); // oczekiwanie na zakończenie zadania task1() (lub zgłoszenie wyjątku)
    }
    catch (const exception& e) {
        cerr << "WYJĄTEK: " << e.what() << endl;
    }
}
