/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    // dane zrodlowe
    int source[] = { 1, 4, 4, 6, 1, 2, 2, 3, 1, 6, 6, 6, 5, 7,
                      5, 4, 4 };

    list<int> coll;

    // zainicjalizuj kolekcje coll elementami z tablicy source
    copy (begin(source), end(source),         // zrodlo
          back_inserter(coll));               // przeznaczenie
    PRINT_ELEMENTS(coll);

    // usun kolejne powtorzenia
    auto pos = unique (coll.begin(), coll.end());

    // wypisz nieusuniete elementy
    // - uzyj nowego logicznego konca
    copy (coll.begin(), pos,                  // zrodlo
          ostream_iterator<int>(cout," "));   // przeznaczenie
    cout << "\n\n";

    // ponownie zainicjalizuj kolekcje coll elementami z tablicy source
    copy (begin(source), end(source),         // zrodlo
          coll.begin());                      // przeznaczenie
    PRINT_ELEMENTS(coll);

    // usun elementy, jesli istnieje wczesniejszy element o wiekszej wartosci
    coll.erase (unique (coll.begin(), coll.end(),
                        greater<int>()),
                coll.end());
    PRINT_ELEMENTS(coll);
}
