/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;
using namespace std::placeholders;
int main()
{
    vector<int> coll1;
    list<int> coll2;

    INSERT_ELEMENTS(coll1,1,9);
    PRINT_ELEMENTS(coll1,"coll1:   ");

    // wykonaj negacje wszystkich elementow w kolekcji coll1
    transform (coll1.cbegin(), coll1.cend(),    // zakres zrodlowy
               coll1.begin(),                   // zakres docelowy
               negate<int>());                  // operacja
    PRINT_ELEMENTS(coll1,"po negacji: ");

    // przeksztalc elementy kolekcji coll1 do coll2 mnozac je przez 10
    transform (coll1.cbegin(), coll1.cend(),    // zakres zrodlowy
               back_inserter(coll2),            // zakres docelowy
               bind(multiplies<int>(),_1, 10)); // operacja
    PRINT_ELEMENTS(coll2,"coll2:   ");

    // wypisz kolekcje coll2 zanegowana i w odwrotnej kolejnosci
    transform (coll2.crbegin(), coll2.crend(),  // zakres zrodlowy
               ostream_iterator<int>(cout," "), // zakres docelowy
               [](int elem) {                   // operacja
                   return -elem;
               });
    cout << endl;
}
