/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;
using namespace std::placeholders;

int main()
{
    list<int> coll1;

    INSERT_ELEMENTS(coll1,1,6);
    INSERT_ELEMENTS(coll1,1,9);
    PRINT_ELEMENTS(coll1);

    // wypisz wszystkie elementy oprocz tych o wartosci 3
    remove_copy(coll1.cbegin(), coll1.cend(),       // źródło
                ostream_iterator<int>(cout," "),    // przeznaczenie
                3);                                 // usuwana wartość
    cout << endl;

    // wypisz wszystkie elementy oprocz tych o wartosciach wiekszych od 4
    remove_copy_if(coll1.cbegin(), coll1.cend(),    // źródło
                   ostream_iterator<int>(cout," "), // przeznaczenie
                   [](int elem){      // kryterium dla niekopiowanych elementów
                       return elem>4;
                   });
    cout << endl;

    // kopiuj wszystkie elementy wieksze od 3 do wielozbioru
    multiset<int> coll2;
    remove_copy_if(coll1.cbegin(), coll1.cend(),    // źródło
                   inserter(coll2,coll2.end()),     // przeznaczenie
                   bind(less<int>(),_1,4));         // niekopiowane elementy
    PRINT_ELEMENTS(coll2);
}
