/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll;

    INSERT_ELEMENTS(coll,1,3);
    PRINT_ELEMENTS(coll,"poczatkowo:  ");

    // permutuj elementy tak dlugo, az beda one posortowane
    // - przechodzi przez wszystkie permutacje, poniewaz elementy sa posortowane
    while (next_permutation(coll.begin(),coll.end())) {
        PRINT_ELEMENTS(coll," ");
    }
    PRINT_ELEMENTS(coll,"potem:       ");

    // permutuj tak dlugo, az elementy beda posortowane malejaco
    // - jest to nastepna permutacja po sortowaniu rosnaco
    // - wiec petla natychmiast konczy swoje wykonywanie
    while (prev_permutation(coll.begin(),coll.end())) {
        PRINT_ELEMENTS(coll," ");
    }
    PRINT_ELEMENTS(coll,"teraz:       ");

    // permutuj elementy tak dlugo, az beda one posortowane malejaco
    // - przechodzi przez wszystkie permutacje, poniewaz elementy sa teraz
    //   posortowane malejaco
    while (prev_permutation(coll.begin(),coll.end())) {
        PRINT_ELEMENTS(coll," ");
    }
    PRINT_ELEMENTS(coll,"potem:       ");
}
