/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll1 = { 9, 8, 7, 7, 7, 5, 4, 2, 1 };
    vector<int> coll2 = { 5, 3, 2, 1, 4, 7, 9, 8, 6 };
    PRINT_ELEMENTS(coll1,"coll1: ");
    PRINT_ELEMENTS(coll2,"coll2: ");

    // sprawdź, czy kolekcje są stogami
    cout << boolalpha << "coll1 jest stogiem: "
         << is_heap (coll1.cbegin(), coll1.cend()) << endl;
    cout << "coll2 jest stogiem: "
         << is_heap (coll2.cbegin(), coll2.cend()) << endl;

    // wypisz pierwszy element naruszający uporządkowanie stogowe w coll2
    auto pos = is_heap_until (coll2.cbegin(), coll2.cend());
    if (pos != coll2.end()) {
        cout << "pierwszy element spoza stogu: " << *pos << endl;
    }
}
