/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    // wypisz dziesięć razy wartość 7.7
    fill_n(ostream_iterator<float>(cout, " "), // początek zakresu docelowego
           10,                                 // count
           7.7);                               // new value
    cout << endl;

    list<string> coll;

    // wstaw dziewięć razy łańcuch "witaj"
    fill_n(back_inserter(coll),       // początek zakresu docelowego
           9,                         // liczba elementów
           "witaj");                  // nowa wartość
    PRINT_ELEMENTS(coll,"coll: ");

    // nadpisz wszystkie elementy łańcuchem "znowu"
    fill(coll.begin(), coll.end(),    // przeznaczenie
         "znowu");                    // nowa wartość
    PRINT_ELEMENTS(coll,"coll: ");

    // zastąp wszystkie elementy oprócz dwóch łańcuchem "cześć"
    fill_n(coll.begin(),              // początek zakresu docelowego
           coll.size()-2,             // liczba elementów
           "cześć");                     // nowa wartość
    PRINT_ELEMENTS(coll,"coll: ");

    // zastąp elementy od drugiego do przedostatniego łańcuchem "hmmm"
    list<string>::iterator pos1, pos2;
    pos1 = coll.begin();
    pos2 = coll.end();
    fill (++pos1, --pos2,              // zakres docelowy
          "hmmm");                     // nowa wartość
    PRINT_ELEMENTS(coll,"coll: ");
}
