/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

// sprawdź, czy elem2 ma dwukrotnie większą wartość niż elem1
bool doubled (int elem1, int elem2)
{
   return elem1 * 2 == elem2;
}

int main()
{
   vector<int> coll;

   coll.push_back(1);
   coll.push_back(3);
   coll.push_back(2);
   coll.push_back(4);
   coll.push_back(5);
   coll.push_back(5);
   coll.push_back(0);

   PRINT_ELEMENTS(coll,"coll: ");

   // znajdź pierwsze dwa elementy o równych wartościach
   vector<int>::iterator pos;
   pos = adjacent_find (coll.begin(), coll.end());

   if (pos != coll.end()) {
       cout << "pierwsze dwa elementy o równych wartościach na pozycji "
            << distance(coll.begin(),pos) + 1
            << endl;
   }

   // znajdź pierwsze dwa elementy, z których drugi ma dwukrotnie większą wartość niż pierwszy
   pos = adjacent_find (coll.begin(), coll.end(),   // zakres
                        doubled);                   // kryterium

   if (pos != coll.end()) {
       cout << "pierwsze dwa elementy, z których drugi ma dwukrotnie większą wartość"
            << " na pozycji "
            << distance(coll.begin(),pos) + 1
            << endl;
   }
}
