/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <exception>
#include <system_error>
#include <future>
#include <iostream>

template <typename T>
void processCodeException (const T& e)
{
    using namespace std;
    auto c = e.code();
    cerr << "- kategoria: " << c.category().name() << endl;
    cerr << "- wartość: " << c.value() << endl;
    cerr << "- opis: " << c.message() << endl;
    cerr << "- domyślna kategoria: "
         << c.default_error_condition().category().name() << endl;
    cerr << "- domyślna wartość: "
         << c.default_error_condition().value() << endl;
    cerr << "- domyślny opis: "
         << c.default_error_condition().message() << endl;
}

void processException()
{
    using namespace std;
    try {
        throw; // ponowne zgłoszenie wyjątku do dopasowania
    }
    catch (const ios_base::failure& e) {
        cerr << "WYJĄTEK I/O: " << e.what() << endl;
        processCodeException(e);
    }
    catch (const system_error& e) {
        cerr << "WYJĄTEK SYSTEMOWY: " << e.what() << endl;
        processCodeException(e);
    }
    catch (const future_error& e) {
        cerr << "WYJĄTEK WYKONANIA ASYNCHRONICZNEGO: " << e.what() << endl;
        processCodeException(e);
    }
    catch (const bad_alloc& e) {
        cerr << "WYJĄTEK ALOKACJI: " << e.what() << endl;
    }
    catch (const exception& e) {
        cerr << "WYJĄTEK: " << e.what() << endl;
    }
    catch (...) {
        cerr << "WYJĄTEK (nieznany)" << endl;
    }
}

