/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <string>
using namespace std;

int main (int argc, char** argv)
{
   const string delims(" \t,.;");
   string line;

   // dla kazdego prawidlowo odczytanego wiersza
   while (getline(cin,line)) {
       string::size_type begIdx, endIdx;

       // odszukaj poczatek pierwszego slowa
       begIdx = line.find_first_not_of(delims);

       // w chwili odnalezienia poczatku slowa
       while (begIdx != string::npos) {
           // odszukaj koniec rzeczywistego slowa
           endIdx = line.find_first_of (delims, begIdx);
           if (endIdx == string::npos) {
               // koniec slowa jest jednoczesnie koncem wiersza
               endIdx = line.length();
           }

           // wypisz znaki w odwrotnej kolejnosci
           for (int i=endIdx-1; i>=static_cast<int>(begIdx); --i) {
               cout << line[i];
           }
           cout << ' ';

           // odszukaj poczatek kolejnego slowa
           begIdx = line.find_first_not_of (delims, endIdx);
       }
       cout << endl;
   }
}
