/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <algorithm>
#include <vector>
#include <iostream>
using namespace std;

int main()
{
    vector<int> coll;
    vector<int>::iterator pos;
    // wstaw elementy od 1 do 6 w przypadkowej kolejności
    coll.push_back(2);
    coll.push_back(5);
    coll.push_back(4);
    coll.push_back(1);
    coll.push_back(6);
    coll.push_back(3);

    // znajdź i wypisz element o najmniejszej i największej wartości
    pos = min_element (coll.begin(), coll.end());
    cout << "min: " << *pos << endl;
    pos = max_element (coll.begin(), coll.end());
    cout << "max: " << *pos << endl;

    // posortuj wszystkie elementy
    sort (coll.begin(), coll.end());

    // znajdź pierwszy element o wartości 3
    pos = find (coll.begin(), coll.end(),  // zakres
                3);                        // wartość

    // odwróć kolejność elementów począwszy od znalezionego elementu o wartości 3 aż do końca
    reverse (pos, coll.end());

    // wypisz wszystkie elementy
    for (pos=coll.begin(); pos!=coll.end(); ++pos) {
        cout << *pos << ' ';
    }
    cout << endl;
}
