/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <regex>
#include <iostream>
#include <algorithm>
using namespace std;

int main()
{
    string data = "<osoba>\n"
                  " <imie>Norbert</imie>\n"
                  " <nazwisko>Jankowski</nazwisko>\n"
                  "</osoba>\n";

    regex reg("<(.*)>(.*)</(\\1)>");

    // iterowanie po wszystkich dopasowaniach (z wykorzystaniem iteratorów regex_token_iterator):
    sregex_token_iterator pos(data.cbegin(),data.cend(), // ciąg
                              reg,                       // separator tokenu
                              {0,2});     // 0: pełne dopasowanie, 2: drugi podciąg
    sregex_token_iterator end;
    for ( ; pos!=end ; ++pos ) {
        cout << "match: " << pos->str() << endl;
    }
    cout << endl;

    string names = "norbert, jan, henryk, pawel, tomasz, jan pawel, regina";
    regex sep("[ \t\n]*[,;.][ \t\n]*"); // rozdzielone , ; lub . i spacjami
    sregex_token_iterator p(names.cbegin(),names.cend(), // ciąg
                            sep,                         // separator
                            -1);                         // -1: wartości pomiędzy separatorami
    sregex_token_iterator e;
    for ( ; p!=e ; ++p ) {
        cout << "imię: " << *p << endl;
    }
}
