/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <regex>
#include <iostream>
using namespace std;

int main()
{
    string data = "<osoba>\n"
                  " <imie>Norbert</imie>\n"
                  " <nazwisko>Jankowski</nazwisko>\n"
                  "</osoba>\n";

    regex reg("<(.*)>(.*)</(\\1)>");

    // iterowanie po wszystkich dopasowaniach 
    auto pos=data.cbegin();
    auto end=data.cend();
    smatch m;
    for ( ; regex_search(pos,end,m,reg); pos=m.suffix().first) {
        cout << "dopasowanie: " << m.str() << endl;
        cout << " znacznik: " << m.str(1) << endl;
        cout << " wartość: " << m.str(2) << endl;
    }
}
