/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <complex>
using namespace std;

int main()
{
    // liczba zespolona z częścią rzeczywistą oraz urojoną
    // - część rzeczywista: 4.0
    // - część urojona: 3.0
    complex<double> c1(4.0,3.0);

    // tworzy liczbę zespoloną przy wykorzystaniu współrzędnych biegunowych
    // - moduł: 5.0
    // - kąt fazy: 0.75
    complex<float> c2(polar(5.0,0.75));

    // wyświetla część rzeczywistą oraz urojoną liczb zespolonych
    cout << "c1: " << c1 << endl;
    cout << "c2: " << c2 << endl;

    // wyświetla liczby zespolone w postaci współrzędnych biegunowych
    cout << "c1: moduł: " << abs(c1)
         << " (kwadrat modułu: " << norm(c1) << ") "
         <<    " kąt fazy: " << arg(c1) << endl;
    cout << "c2: moduł: " << abs(c2)
         << " (kwadrat modułu: " << norm(c2) << ") "
         <<    " kąt fazy: " << arg(c2) << endl;

    // wyświetla sprzężone liczby zespolone
    cout << "c1 sprzężona liczba zespolona:  " << conj(c1) << endl;
    cout << "c2 sprzężona liczba zespolona:  " << conj(c2) << endl;
    // wyświetla wynik obliczeń
    cout << "4.4 + c1 * 1.8: " << 4.4 + c1 * 1.8 << endl;

    // wyświetla sumę liczb c1 oraz c2:
    // - uwaga: użyte zostały różne typy
    cout << "c1 + c2:        "
         << c1 + complex<double>(c2.real(),c2.imag()) << endl;

    // dodaje pierwiastek kwadratowy liczby c1 do c1 oraz wyświetla wynik
    cout << "c1 += sqrt(c1): " << (c1 += sqrt(c1)) << endl;
}
