/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <exception>
#include <cstdlib>

namespace MyLib {
    double readAndProcessSum (std::istream&);
}

int main()
{
    using namespace std;
    double sum;

    try {
        sum = MyLib::readAndProcessSum(cin);
    }
    catch (const ios::failure& error) {
        cerr << "qyjątek wejścia-wyjścia: " << error.what() << endl;
        return EXIT_FAILURE;
    }
    catch (const exception& error) {
        cerr << "wyjątek standardowy: " << error.what() << endl;
        return EXIT_FAILURE;
    }
    catch (...) {
        cerr << "nieznany wyjątek" << endl;
        return EXIT_FAILURE;
    }

    // wypisz sumę
    cout << "suma: " << sum << endl;
}

#include <istream>

namespace MyLib {
    double readAndProcessSum (std::istream& strm)
    {
        double value, sum;
    
        // dopóki strumień jest w porządku
        // - wczytuj wartości i dodawaj je do sumy
        sum = 0;
        while (strm >> value) {
            sum += value;
        }
    
        if (!strm.eof()) {
            throw std::ios::failure
                    ("błąd wejścia w readAndProcessSum()");
        }
    
        // zwróć sumę
        return sum;
    }
}
