/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
// header files for file I/O
#include <iostream>
#include <fstream>

void printFileTwice (const char* filename)
{
    // otwórz plik
    std::ifstream file(filename);

    // po raz pierwszy wypisz zawartość pliku
    std::cout << file.rdbuf();

    // przesuń na początek
    file.seekg(0);

    // po raz drugi wypisz zawartość pliku
    std::cout << file.rdbuf();
}

int main (int argc, char* argv[])
{
    // wypisz dwukrotnie zawartość wszystkich plików przekazanych jako argumenty wywołania
    for (int i=1; i<argc; ++i) {
        printFileTwice(argv[i]);
    }
}
